<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Common;
use App\Models\Pratice_Quiz_Leaderboard;
use App\Models\Refer_Earn;
use App\Models\User;
use App\Models\User_Badge_List;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Validation\Rule;

// Login Type : 1= OTP, 2= Goggle, 3= Apple, 4= Normal
class UserController extends Controller
{
    private $folder = "user";
    private $folder_badge = "badge";
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index(Request $request)
    {
        try {

            $params['data'] = [];
            if ($request->ajax()) {

                $input_search = $request['input_search'];
                $input_type = $request['input_type'];
                $input_login_type = $request['input_login_type'];

                $query = User::latest();
                if ($input_search) {
                    $query->where(function ($q) use ($input_search) {
                        $q->where('full_name', 'LIKE', "%{$input_search}%")
                            ->orWhere('user_name', 'LIKE', "%{$input_search}%")
                            ->orWhere('email', 'LIKE', "%{$input_search}%")
                            ->orWhere('mobile_number', 'LIKE', "%{$input_search}%");
                    });
                }
                if ($input_login_type !== 'all') {
                    $query->where('type', $input_login_type);
                }
                if ($input_type == 'today') {
                    $query->whereDay('created_at', date('d'))->whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'));
                } elseif ($input_type == 'month') {
                    $query->whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'));
                } elseif ($input_type == 'year') {
                    $query->whereYear('created_at', date('Y'));
                }
                $data = $query->latest()->get();

                $this->common->userImage($data);

                return DataTables()::of($data)
                    ->addIndexColumn()
                    ->addColumn('action', function ($row) {

                        $user_delete = __('label.delete_user');

                        $delete = '<form onsubmit="return confirm(\'' . $user_delete . '\');" method="POST" action="' . route('admin.user.destroy', [$row->id]) . '">
                        <input type="hidden" name="_token" value="' . csrf_token() . '">
                        <input type="hidden" name="_method" value="DELETE">
                        <button type="submit" class="edit-delete-btn" style="outline: none;"><i class="fa-solid fa-trash-can fa-xl"></i></button></form>';

                        $btn = '<div class="d-flex justify-content-around">';
                        $btn .= '<a href="' . route('admin.user.dashboard', [$row->id]) . '" class="edit-delete-btn mr-2">';
                        $btn .= '<i class="fa-solid fa-gauge fa-xl"></i>';
                        $btn .= '</a>';
                        $btn .= '<a href="' . route('admin.user.edit', [$row->id]) . '" class="edit-delete-btn mr-2">';
                        $btn .= '<i class="fa-solid fa-pen-to-square fa-xl"></i>';
                        $btn .= '</a>';
                        $btn .= $delete;
                        $btn .= '</div>';
                        return $btn;
                    })
                    ->addColumn('date', function ($row) {
                        return date("Y-m-d", strtotime($row['created_at']));
                    })
                    ->addColumn('status', function ($row) {
                        if ($row->status == 1) {
                            $showLabel = __('label.active');
                            return "<button type='button' id='$row->id' onclick='change_status($row->id)' class='show-btn'>$showLabel</button>";
                        } else {
                            $hideLabel = __('label.inactive');
                            return "<button type='button' id='$row->id' onclick='change_status($row->id)' class='hide-btn'>$hideLabel</button>";
                        }
                    })
                    ->rawColumns(['action', 'status'])
                    ->make(true);
            }
            return view('admin.user.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function create()
    {
        try {
            return view('admin.user.add');
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function store(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'full_name' => 'required|min:2',
                'country_code' => 'required',
                'country_name' => 'required',
                'mobile_number' => [
                    'required',
                    'numeric',
                    Rule::unique('tbl_user')->where(function ($query) use ($request) {
                        return $query->where('country_code', $request['country_code'])
                            ->where('mobile_number', $request['mobile_number']);
                    }),
                ],
                'email' => 'required|unique:tbl_user|email',
                'password' => 'required|min:4',
                'image' => 'required|image|mimes:jpeg,png,jpg|max:5120',
            ]);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(['status' => 400, 'errors' => $errs]);
            }

            $user = new User();
            $email_array = explode('@', $request['email']);
            $user['user_name'] = $this->common->user_name($email_array[0]);
            $user['full_name'] = $request['full_name'];
            $user['email'] = $request['email'];
            $user['password'] = Hash::make($request['password']);
            $user['country_code'] = $request['country_code'];
            $user['mobile_number'] = $request['mobile_number'];
            $user['country_name'] = $request['country_name'];
            $user['type'] = 4;
            $user['image_type'] = 1;
            $files = $request['image'];
            $user['image'] = $this->common->saveImage($files, $this->folder, 'user_');
            $user['bio'] = $request['bio'] ?? $this->common->user_bio();
            $user['reference_code'] = $this->common->generateReferralCode(6);
            $user['wallet_coin'] = 0;
            $user['device_type'] = 0;
            $user['device_token'] = "";
            $user['qr_code'] = "";
            $user['is_account_verify'] = 0;
            $user['status'] = 1;
            if ($user->save()) {

                $user['qr_code'] = $this->common->create_qr_code($user['id']);
                $user->save();

                return response()->json(['status' => 200, 'success' => __('label.success_add_user')]);
            } else {
                return response()->json(['status' => 400, 'errors' => __('label.error_add_user')]);
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function edit($id)
    {
        try {

            $params['result'] = User::where('id', $id)->first();
            if (isset($params['result']['id'])) {

                $this->common->userImage(array($params['result']));
                return view('admin.user.edit', $params);
            } else {
                return redirect()->back()->with('error', __('label.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function update($id, Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'full_name' => 'required|min:2',
                'email' => 'required|email|unique:tbl_user,email,' . $id,
                'country_code' => 'required',
                'country_name' => 'required',
                'mobile_number' => [
                    'required',
                    'numeric',
                    Rule::unique('tbl_user')->where(function ($query) use ($request, $id) {
                        return $query->where('country_code', $request['country_code'])
                            ->where('mobile_number', $request['mobile_number'])
                            ->where('id', '!=', $id);
                    }),
                ],
                'image' => 'image|mimes:jpeg,png,jpg|max:5120',
            ]);
            if ($validator->fails()) {
                $errs = $validator->errors()->all();
                return response()->json(['status' => 400, 'errors' => $errs]);
            }

            $user = User::where('id', $request['id'])->first();
            if ($user) {

                $user['full_name'] = $request['full_name'];
                $user['country_code'] = $request['country_code'];
                $user['mobile_number'] = $request['mobile_number'];
                $user['country_name'] = $request['country_name'];
                $user['email'] = $request['email'];
                if ($request['password'] != null && isset($request['password'])) {
                    $user['password'] = Hash::make($request['password']);
                }
                $user['bio'] = $request['bio'] ?? $this->common->user_bio();
                if (isset($request['image'])) {
                    $user['image_type'] = 1;
                    $files = $request['image'];
                    $user['image'] = $this->common->saveImage($files, $this->folder, 'user_');

                    $this->common->deleteImageToFolder($this->folder, basename($request['old_image']));
                }
                if ($user->save()) {
                    return response()->json(['status' => 200, 'success' => __('label.success_edit_user')]);
                } else {
                    return response()->json(['status' => 400, 'errors' => __('label.error_edit_user')]);
                }
            } else {
                return response()->json(['status' => 400, 'errors' => __('label.error_edit_user')]);
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function destroy($id)
    {
        try {

            $data = User::where('id', $id)->first();
            if (isset($data)) {
                $this->common->deleteImageToFolder($this->folder, $data['image']);
                $this->common->deleteImageToFolder($this->folder, $data['qr_code']);
                $data->delete();

                Pratice_Quiz_Leaderboard::where('user_id', $id)->delete();
                User_Badge_List::where('user_id', $id)->delete();
            }
            return redirect()->route('admin.user.index')->with('success', __('label.user_delete'));
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function show($id)
    {
        try {

            $data = User::where('id', $id)->first();
            if (isset($data)) {

                $data['status'] = $data['status'] === 1 ? 0 : 1;
                $data->save();
                return response()->json(['status' => 200, 'success' => __('label.status_changed'), 'status_code' => $data->status]);
            } else {
                return response()->json(['status' => 400, 'errors' => __('label.data_not_found')]);
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function dashboard($id, Request $request)
    {
        try {

            $params['data'] = User::where('id', $id)->first();
            if ($params['data'] != null) {

                $params['id'] = $id;
                $this->common->userImage(array($params['data']));
                $params['data']['qr_code'] = $this->common->getFile($this->folder, $params['data']['qr_code']);

                $params['badges'] = User_Badge_List::where('user_id', $id)->with('badge')->latest()->get();
                for ($i = 0; $i < count($params['badges']); $i++) {

                    if ($params['badges'][$i]['badge'] != null) {
                        $params['badges'][$i]['badge']['image'] = $this->common->getImage($this->folder_badge, $params['badges'][$i]['badge']['image']);
                    }
                }

                $params['parent_user'] = Refer_Earn::where('child_user_id', $id)->with('parent_user')->latest()->get();
                for ($i = 0; $i < count($params['parent_user']); $i++) {

                    if ($params['parent_user'][$i]['parent_user'] != null) {
                        $this->common->userImage(array($params['parent_user'][$i]['parent_user']));
                    }
                }
                $params['child_user'] = Refer_Earn::where('parent_user_id', $id)->with('child_user')->latest()->get();
                for ($i = 0; $i < count($params['child_user']); $i++) {

                    if ($params['child_user'][$i]['child_user'] != null) {
                        $this->common->userImage(array($params['child_user'][$i]['child_user']));
                    }
                }

                return view('admin.user.dashboard', $params);
            } else {
                return redirect()->back()->with('error', __('label.data_not_found'));
            }
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
